import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(6, 9))

# Define the grid size
rows, cols = 6, 4

# Define colors for each piece
colors = {
    "rightl0": "blue",
    "rightl1": "green",
    "square0": "red",
    "square1": "yellow",
    "clear": "lightgrey"
}

# Function to draw a square with text
def draw_square(ax, x, y, text, color, status):
    # Draw the square
    rect = patches.Rectangle((x, y), 1, 1, linewidth=2, edgecolor='black', facecolor=color)
    ax.add_patch(rect)
    # Add text
    ax.text(x + 0.5, y + 0.7, text, va='center', ha='center', fontsize=8, color='black', fontweight='bold')
    ax.text(x + 0.5, y + 0.3, status, va='center', ha='center', fontsize=6, color='black')

# Draw the grid and pieces
for row in range(rows):
    for col in range(cols):
        pos = f"f{row}-{col}f"
        if pos in ["f3-0f", "f3-1f", "f2-0f"]:
            draw_square(ax, col, rows - row - 1, "rightl0", colors["rightl0"], "occupied")
        elif pos in ["f1-0f", "f1-1f", "f0-0f"]:
            draw_square(ax, col, rows - row - 1, "rightl1", colors["rightl1"], "occupied")
        elif pos == "f1-2f":
            draw_square(ax, col, rows - row - 1, "square0", colors["square0"], "occupied")
        elif pos == "f2-2f":
            draw_square(ax, col, rows - row - 1, "square1", colors["square1"], "occupied")
        else:
            draw_square(ax, col, rows - row - 1, pos, colors["clear"], "clear")

# Set limits and remove axes
ax.set_xlim(0, cols)
ax.set_ylim(0, rows)
ax.set_xticks([])
ax.set_yticks([])
ax.set_aspect('equal')

# Add a legend
legend_elements = [
    patches.Patch(facecolor=colors["rightl0"], edgecolor='black', label='rightl0: occupied'),
    patches.Patch(facecolor=colors["rightl1"], edgecolor='black', label='rightl1: occupied'),
    patches.Patch(facecolor=colors["square0"], edgecolor='black', label='square0: occupied'),
    patches.Patch(facecolor=colors["square1"], edgecolor='black', label='square1: occupied'),
    patches.Patch(facecolor=colors["clear"], edgecolor='black', label='clear: available')
]
ax.legend(handles=legend_elements, loc='upper right', fontsize=8)

# Save the figure
plt.savefig('tetris/one_shot/ini_diagram_code/attempts/attempt_36.png', bbox_inches='tight')
plt.show()